unit SMTPSend;

{*****************************************************************
 *  Unit:  SMTPSend                                              *
 *  Zweck: Versenden einer e-Mail aus Daten, bergeben mittels   *
 *         einer speziellen Datenstruktur TSMTPStruct            *
 *         (Die e-Mail wird als                                  *
 *         Content-Type: text/plain; charset=iso-8859-1    mit   *
 *         Content-Transfer-Encoding: 8bit            gesendet)  *
 *  Autor: Jrgen Hummel *** post@hummel1.de *** www.hummel1.de  *
 *  Stand: 2000-01-30                                            *
 *****************************************************************}

interface

uses Classes;

type TSMTPStruct = record    {Datenstruktur zur bergabe der Mail}
 Server:   String;           {Name des zu benutzenden SMTP-Servers}
 Receiver: String;           {Empfnger der e-Mail}
 From:     String;           {e-Mail-Adresse des Absenders}
 Sender:   String;           {Absendername im Klartext}
 Subject:  String;           {Mail-Betreff}
 Content:  TStringList;      {Textinhalt der e-Mail in Zeilenform}
end;

type PSMTPStruct=^TSMTPStruct;

                        {Ergebniswerte der Funktion SMTPSendMail}
const SMTP_MAILOK  =0;  {Mail korrekt gesendet}
      SMTP_TRANSERR=1;  {Server meldet Fehler beim bertragen der Mail}
      SMTP_NOSERVER=2;  {Mail-Server nicht gefunden/nicht verfgbar}
      SMTP_NONET   =3;  {keine TCP/IP-Netzverbindung}
      SMTP_NOPARAMS=4;  {nicht gengend Parameter zum Senden}

function SMTPSendMail(SMTPDat: TSMTPStruct): Integer;

implementation
