{*******************************************************}
{                                                       }
{   Delphi Hilfsroutinen zur ISAPI-Programmierung       }
{   (Diese Routinen drfen frei verwendet werden.)      }
{                                                       }
{   Dateiversion: 99-08-08                              }
{   Version: Delphi 3                                   }
{   Autor: Jrgen Hummel    ***    post@hummel1.de      }
{                                                       }
{*******************************************************}

unit IsapiHlp;

interface

uses Windows, Classes, SysUtils, Isapi;

function ECBSize: DWORD;
function ECBVersion: DWORD;
function ECBConnID: Integer;
function ECBHttpStatusCode: DWORD;
function ECBLogData: PChar;
function ECBMethod: PChar;
function ECBQueryString: PChar;
function ECBPathInfo: PChar;
function ECBPathTranslated: PChar;
function ECBTotalBytes: DWORD;
function ECBAvailable: DWORD;
function ECBData: PChar;
function ECBContentType: PChar;
function GetVar(ServerVar: PChar): String;

function GetContentData(var List: TStringList): Boolean;
function HxToInt(c: Char): Byte;
function HtmlHeader(const sTitle, sBgColor, sGroundPic: String): String;
function HtmlFooter: String;
function HtmlLink(const sRef, sText: String): String;

threadvar pECB: PEXTENSION_CONTROL_BLOCK;

implementation

{ --- ISAPI-Hilfsroutinen ----------------------------------------------------}

function ECBSize: DWORD;
begin ECBSize:=pECB.cbSize end;

function ECBVersion: DWORD;
begin ECBVersion:=pECB.dwVersion end;

function ECBConnID: Integer;
begin ECBConnID:=pECB.ConnID end;

function ECBHttpStatusCode: DWORD;
begin ECBHttpStatusCode:=pECB.dwHttpStatusCode end;

function ECBLogData: PChar;
begin ECBLogData:=@pECB.lpszLogData[0] end;

function ECBMethod: PChar;
begin ECBMethod:=pECB.lpszMethod end;

function ECBQueryString: PChar;
begin ECBQueryString:=pECB.lpszQueryString end;

function ECBPathInfo: PChar;
begin ECBPathInfo:=pECB.lpszPathInfo end;

function ECBPathTranslated: PChar;
begin ECBPathTranslated:=pECB.lpszPathTranslated end;

function ECBTotalBytes: DWORD;
begin ECBTotalBytes:=pECB.cbTotalBytes end;

function ECBAvailable: DWORD;
begin ECBAvailable:=pECB.cbAvailable end;

function ECBData: PChar;
begin ECBData:=pECB.lpbData end;

function ECBContentType: PChar;
begin ECBContentType:=pECB.lpszContentType end;

function GetVar(ServerVar: PChar): String;
var cBuf: array[0..1535]of Char; BufLen: DWORD; DumB: BOOL;
begin
 BufLen:=SizeOf(cBuf);
 FillChar(cBuf,BufLen,#0);
 DumB:=pECB.GetServerVariable(pECB.ConnID,ServerVar,Addr(cBuf),BufLen);
 GetVar:=cBuf;
end;

{ --------------------------------------------------------------------------- }

function HxToInt(c: Char): Byte;               {Dezimalwert eines Hex-Zeichens}
var n: Byte;
begin n:=Ord(UpCase(c))-48; if n>9 then Dec(n,7); HxToInt:=n; end;

function GetContentData(var List: TStringList): Boolean;       {decodieren von}
var pCont: PChar;                                              {Formulardaten }
    nContentLength, i, DumI: Integer;
    sPair: String;
begin
 nContentLength:=pECB.cbAvailable;
 if nContentLength>=0 then begin
  pCont:=pECB.lpbData;
  i:=0;
  sPair:='';
  while i<nContentLength do begin                         {Zeichen fr Zeichen}
   case (pCont+i)^ of                                 {Sonderzeichen behandeln}
    '+': sPair:=sPair+' ';
    '%': begin
          sPair:=sPair+Chr((HxToInt((pCont+i+1)^)shl 4)+HxToInt((pCont+i+2)^));
          Inc(i,2);
        end;
    '&': begin DumI:=List.Add(sPair); sPair:='' end;
    else sPair:=sPair+(pCont+i)^;                               {Normalzeichen}
   end;
   Inc(i,1);
  end;
  DumI:=List.Add(sPair);
  GetContentData:=true;
 end else GetContentData:=false;
end;

{ --- HTML-Hilfsroutinen ---------------------------------------------------- }

function HtmlHeader(const sTitle, sBgColor, sGroundPic: String): String;
var s: String;                        {HTML-Header bis einschlielich BODY-Tag}
begin
 s:='<HTML><HEAD><TITLE>'+sTitle+'</TITLE></HEAD><BODY';
 if sBgColor<>'' then s:=s+' bgcolor=#'+sBgColor;
 if sGroundPic<>'' then s:=s+' background="'+sGroundPic+'"';
 HtmlHeader:=s+'>'
end;

function HtmlFooter: String;                              {HTML-Seitenabschlu}
begin HtmlFooter:='</BODY></HTML>' end;

function HtmlLink(const sRef, sText: String): String;         {Link generieren}
var sTx: String;
begin
 if Length(sText)>0 then sTx:=sText else sTx:=sRef;
 HtmlLink:='<A href="'+sRef+'">'+sTx+'</A>';
end;

end.

